//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Configuration Application Block
//===============================================================================
// Copyright  Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

using System.Configuration;

namespace Microsoft.Practices.EnterpriseLibrary.Configuration
{
	/// <summary>
	/// Represents a configuration source that is based on <see cref="System.Configuration.ConfigurationManager"/>.
	/// </summary>
	public class SystemConfigurationSource : IConfigurationSource
	{
		/// <summary>
		/// Retrieves a specified configuration section for the current application's default configuration.
		/// </summary>
		/// <param name="sectionName">The section name to retrieve.</param>
		/// <returns>The configuration for the section.</returns>
		public object GetSection(string sectionName)
		{
			return ConfigurationManager.GetSection(sectionName);
		}
	}
}
